<?php

/* 
======================================================================
 AutoCzech 1.0
======================================================================

PHP knihovna na prekodovani cestiny

	http://www.webdot.cz/autoczech/

AUTOR: Vojtech Semecky, webmaster@webdot.cz

----------------------------------------------------------------------
LICENCE

Tento program je svobodny software. Je distribuovan pod licenci
GNU GPL 2.0 nebo vyssi (dle vasi volby) tak, jak ji publikovala
nadace Free Software Foundation. Smite jej svobodne pouzivat,
modifikovat a/nebo redistribuovat. Pro detaily se podivejte na:

	anglicky original - http://www.gnu.org/copyleft/gpl.html

	cesky preklad - http://www.gnu.cz/gplcz.html

======================================================================
*/

/* TODO
*/

// Funkce na prevod libovolneho ceskeho textu $str na kodovani $code
// (puvodni kodovani neni nutne znat)
function AutoCzech($str, $code)
{
	// Ceske znaky v ruznych kodovanich (ASCII, Win-1250, ISO 8859-2, UTF-8)
	$autocp['asc'] = array ('A','C','D','E','E','I','N','O','R','S','T','U','U','Y','Z',
	                        'a','c','d','e','e','i','n','o','r','s','t','u','u','y','z');
	$autocp['win'] = array ('','','','','','','','','','','','','','','',
	                        '','','','','','','','','','','','','','','');
	$autocp['iso'] = array ('','','','','','','','','','','','','','','',
	                        '','','','','','','','','','','','','','','');
	$autocp['utf'] = array("\xc3\x81", "\xC4\x8C", "\xC4\x8E", "\xc3\x89", "\xC4\x9A", "\xc3\x8d", "\xC5\x87", "\xc3\x93", "\xC5\x98", "\xC5\xA0", "\xC5\xA4", "\xC3\x9A", "\xC5\xAE", "\xc3\x9d", "\xc5\xbd",
	                       "\xc3\xa1", "\xC4\x8D", "\xC4\x8F", "\xc3\xa9", "\xC4\x9B", "\xc3\xad", "\xC5\x88", "\xc3\xb3", "\xC5\x99", "\xC5\xA1", "\xC5\xA5", "\xC3\xBA", "\xC5\xAF", "\xc3\xbd", "\xc5\xbe");

	// Vsechny ceske znaky ktere je mozne prevadet
	$autocp['merge'] = array_merge ($autocp['utf'], $autocp['win'], $autocp['iso']);

	// Prevod do UTF nelze primo, takze AutoCzech na ISO a pak FromToCzech ISO->UTF.
	if ($code=='utf') {
		$str = AutoCzech($str, 'iso');
		return str_replace($autocp['iso'], $autocp['utf'], $str);
		}
	// ... do vseho osttaniho (ISO, WIN, ASC) muzeme prevezt primo
	else {
		$to = array_merge ($autocp[$code], $autocp[$code], $autocp[$code]);
		return str_replace($autocp['merge'], $to, $str);
	}
}

function GetMetaCharset ($code)
{
	$code = strtolower(substr($code, 0, 3));
	$charset['iso'] = 'iso-8859-2';
	$charset['win'] = 'windows-1250';
	$charset['utf'] = '????';
	$charset['asc'] = 'iso-8859-1';
	return $charset[$code];
}
?>